/*
 * Decompiled with CFR 0.152.
 */
package moe.prwk.emiffect.recipes;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.screen.RecipeScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import moe.prwk.emiffect.EMIffectPlugin;
import moe.prwk.emiffect.mixin.RecipeScreenAccessor;
import moe.prwk.emiffect.util.MobEffectEmiStack;
import moe.prwk.emiffect.util.VersionUtil;
import moe.prwk.emiffect.util.resources.ExtraAppenderLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2356;
import net.minecraft.class_2580;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4174;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class MobEffectInfo
implements EmiRecipe {
    private final List<EmiIngredient> inputs;
    private final List<class_5481> desc;
    private final class_2960 id;
    private int inputStackRow;
    private final MobEffectEmiStack emiStack;

    public MobEffectInfo(class_1291 effect, MobEffectEmiStack emiStack) {
        this.id = emiStack.getId();
        ArrayList<EmiIngredient> inputs0 = new ArrayList<EmiIngredient>();
        class_7923.field_41179.method_40270().forEach(potion -> {
            for (class_1293 instance : ((class_1842)potion.comp_349()).method_8049()) {
                if (!instance.method_5579().equals(effect)) continue;
                inputs0.addAll(List.of(EmiStack.of((class_1799)VersionUtil.setPotion(class_1802.field_8574.method_7854(), (class_6880<class_1842>)potion)), EmiStack.of((class_1799)VersionUtil.setPotion(class_1802.field_8436.method_7854(), (class_6880<class_1842>)potion)), EmiStack.of((class_1799)VersionUtil.setPotion(class_1802.field_8150.method_7854(), (class_6880<class_1842>)potion)), EmiStack.of((class_1799)VersionUtil.setPotion(class_1802.field_8087.method_7854(), (class_6880<class_1842>)potion))));
                break;
            }
        });
        for (class_2248 block : class_7923.field_41175) {
            if (!(block instanceof class_2356)) continue;
            class_2356 flower = (class_2356)block;
            class_1799 stew = new class_1799((class_1935)class_1802.field_8766);
            class_1291 _effect2 = flower.method_10188();
            if (!_effect2.equals(effect)) continue;
            inputs0.add((EmiIngredient)EmiStack.of((class_1799)stew));
            break;
        }
        for (class_1792 item : class_7923.field_41178) {
            class_4174 food = item.method_19264();
            if (food == null || !food.method_19235().stream().map(_effect -> ((class_1293)_effect.getFirst()).method_5579()).toList().contains(effect)) continue;
            inputs0.add((EmiIngredient)EmiStack.of((class_1935)item));
        }
        for (class_1291[] effects : class_2580.field_11801) {
            if (!Arrays.asList(effects).contains(effect)) continue;
            inputs0.add((EmiIngredient)EmiStack.of((class_1935)class_2246.field_10327));
        }
        this.inputs = inputs0;
        this.desc = class_310.method_1551().field_1772.method_1728((class_5348)MobEffectInfo.getDescription(this.id), 110);
        this.inputStackRow = this.inputs.isEmpty() ? 0 : 1;
        int inputColumn = 0;
        for (EmiIngredient ignored : this.inputs) {
            if (inputColumn >= 6) {
                ++this.inputStackRow;
                inputColumn = 0;
            }
            ++inputColumn;
        }
        this.emiStack = emiStack;
    }

    public void addFromAppenders(List<ExtraAppenderLoader.ExtraAppender> appenders) {
        for (ExtraAppenderLoader.ExtraAppender appender : appenders) {
            if (!this.id.equals((Object)appender.effectId())) continue;
            appender.getIngredients().forEach(ingredient -> {
                if (!this.inputs.contains(ingredient)) {
                    this.inputs.add((EmiIngredient)ingredient);
                }
            });
        }
    }

    public EmiRecipeCategory getCategory() {
        return EMIffectPlugin.CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return VersionUtil.identifier("emiffect", "/effects/" + this.id.method_12836() + "/" + this.id.method_12832());
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.emiStack);
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        int n = this.desc.size();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int upperOffset = 14 + Math.max(n * 9, 30) + 2;
        int backgroundHeight = 200;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof RecipeScreen) {
            RecipeScreen screen = (RecipeScreen)class_4372;
            backgroundHeight = ((RecipeScreenAccessor)screen).emiffect$getBackgroundHeight();
        }
        int slotsHeight = this.inputs.isEmpty() ? 0 : ((this.inputs.size() - 1) / 6 + 1) * 18;
        return Math.min(slotsHeight + upperOffset, backgroundHeight);
    }

    public void addWidgets(WidgetHolder widgets) {
        int titleColor = 0xFFFFFF;
        if (this.emiStack.getEffect() != null) {
            switch (this.emiStack.getEffect().method_18792()) {
                case field_18271: {
                    titleColor = class_124.field_1060.method_532();
                    break;
                }
                case field_18273: {
                    titleColor = class_124.field_1065.method_532();
                    break;
                }
                case field_18272: {
                    titleColor = class_124.field_1061.method_532();
                }
            }
        }
        class_5481 title = this.emiStack.getName().method_30937();
        int titleX = 31 + (113 - class_310.method_1551().field_1772.method_30880(title)) / 2;
        widgets.addText(title, titleX, 2, titleColor, true);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int lineHeight = 9;
        int descLine = 0;
        for (class_5481 text : this.desc) {
            widgets.addText(text, 31, 14 + lineHeight * descLine, 0xFFFFFF, true);
            ++descLine;
        }
        int descHeight = Math.max(descLine * lineHeight, 30);
        descHeight += 12;
        int n = this.desc.size();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int upperOffset = 14 + Math.max(n * 9, 30) + 2;
        int ph = this.inputs.isEmpty() ? 0 : (widgets.getHeight() - (upperOffset + 14) - 2) / 18 + 1;
        PageManager manager = new PageManager(this.inputs, 6 * ph);
        if (ph < this.inputStackRow) {
            widgets.addButton(2, upperOffset, 12, 12, 0, 0, () -> true, (mouseX, mouseY, button) -> manager.scroll(-1));
            widgets.addButton(widgets.getWidth() - 14, upperOffset, 12, 12, 12, 0, () -> true, (mouseX, mouseY, button) -> manager.scroll(1));
        }
        for (int i = 0; i < manager.pageSize; ++i) {
            widgets.add((Widget)new PageSlotWidget(manager, i, i % 6 * 18 + 18, i / 6 * 18 + upperOffset));
        }
        SlotWidget effectSlot = new SlotWidget((EmiIngredient)this.emiStack, 3, (descHeight - 26) / 2).large(true).recipeContext((EmiRecipe)this);
        widgets.add((Widget)effectSlot);
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    private static class_5250 getDescription(class_2960 id) {
        if (id.method_12836().equals("minecraft") && id.method_12832().equals("bad_omen")) {
            return EmiPort.translatable((String)"effect.minecraft.bad_omen_legacy.description");
        }
        String firstKey = String.format("effect.%s.%s.description", id.method_12836(), id.method_12832());
        if (class_1074.method_4663((String)firstKey)) {
            return EmiPort.translatable((String)firstKey);
        }
        String secondKey = String.format("effect.%s.%s.desc", id.method_12836(), id.method_12832());
        if (class_1074.method_4663((String)secondKey)) {
            return EmiPort.translatable((String)secondKey);
        }
        return EmiPort.translatable((String)"info.emiffect.desc_not_found");
    }

    private static class PageManager {
        public final List<EmiIngredient> stacks;
        public final int pageSize;
        public int currentPage;

        public PageManager(List<EmiIngredient> stacks, int pageSize) {
            this.stacks = stacks;
            this.pageSize = pageSize;
        }

        public void scroll(int delta) {
            this.currentPage += delta;
            int totalPages = (this.stacks.size() - 1) / this.pageSize + 1;
            if (this.currentPage < 0) {
                this.currentPage = totalPages - 1;
            }
            if (this.currentPage >= totalPages) {
                this.currentPage = 0;
            }
        }

        public EmiIngredient getStack(int offset) {
            if ((offset += this.pageSize * this.currentPage) < this.stacks.size()) {
                return this.stacks.get(offset);
            }
            return EmiStack.EMPTY;
        }

        public EmiRecipe getRecipe(int offset) {
            if ((offset += this.pageSize * this.currentPage) < this.stacks.size()) {
                return EmiApi.getRecipeContext((EmiIngredient)this.stacks.get(offset));
            }
            return null;
        }
    }

    private static class PageSlotWidget
    extends SlotWidget {
        public final PageManager manager;
        public final int offset;

        public PageSlotWidget(PageManager manager, int offset, int x, int y) {
            super((EmiIngredient)EmiStack.EMPTY, x, y);
            this.manager = manager;
            this.offset = offset;
        }

        public EmiIngredient getStack() {
            return this.manager.getStack(this.offset);
        }

        public EmiRecipe getRecipe() {
            return this.manager.getRecipe(this.offset);
        }

        public void method_25394(class_332 draw, int mouseX, int mouseY, float delta) {
            if (!this.getStack().isEmpty()) {
                super.method_25394(draw, mouseX, mouseY, delta);
            }
        }
    }
}

